﻿/********************************************************************/
/*                                                                  */
/* ADOBE SYSTEMS INCORPORATED                                       */
/* Copyright 1986 - 2010 Adobe Systems Incorporated                 */
/* All Rights Reserved                                              */
/*                                                                  */
/* NOTICE:  Adobe permits you to use, modify, and distribute this   */
/* file in accordance with the terms of the Adobe license agreement */
/* accompanying it.  If you have received this file from a source   */
/* other than Adobe, then your use, modification, or distribution   */
/* of it requires the prior written permission of Adobe.            */
/*                                                                  */
/********************************************************************/
/*
 * Program Name:                                                     
 *    << FM_lib.jsx  >>                                                    
 *                                                                   
 * General Description:                                              
 *    This is the library of functions being used in the parent script FM_Flatten_Conrefs.jsx
 *     
 *********************************************************************/      

//function for opening all the topicrefs in the map file

function openAllTopicRefs(mapName) {
	
//var doc = openinvisible(mapName)
doc = app.ActiveDoc
docPath =  doc.Name
 ti = doc.FirstTiInDoc

j = 0

while(ti.ObjectValid()  ) {
	
var tloc = ti.TextRange.beg

var eloc = doc.TextLocToElementLoc(tloc)

var ele = eloc.child
var  ele1 = eloc.parent

  if (ele.ElementDef.Name == "fm-topicreflabel")
{
	var parName = ele1.ElementDef.Name
	if ( (parName == "topicref") ||  (parName == "chapter") )
	{
			var attr =ele1.Attributes
			var idval = attr[1].values
			var path = idval[0]
			var arr1 = idval[0].split("\\")
            
        
			if (arr1[0] == idval[0] ) {
				 path  = getAbsolutePath(idval[0])
			}
        
                 
             var format = attr[10].values
            if (format !="ditamap" )
            {
			//doc1 = openinvisible(path)
            doc1 = openinvisible(path)
            if (doc1.id != 0) {
        

        
             Count =  convertConrefDitaMap(doc1)
             tCount = Count + tCount
             saveXml(doc1,doc1.Name)
            doc1.Close(Constants.FF_CLOSE_MODIFIED)
               
			}
                else {
                   Console("There were errors in opening the file :" + path)
               }
           }
            else
            {
                 listOfFile.push(path)
                openAllTopicRefs(path)
                                
              }      

	}
		
}

	ti = ti.NextTiInDoc
}

}

//Function for getting the Absolute path of the file

function getAbsolutePath(str) {
	
		var arr = docPath.split("\\")
		
		arr.pop()
	var absPath = arr.join("\\")
	
	absPath = absPath.concat("\\",str)
	return absPath;
}

//Function for finding the instances in a single document

function findInDoc(docObj) {
	//var doc = open(fileName)
var count = 0
ti = docObj.FirstTiInDoc

while(ti.id != 0) {
	
var tloc = ti.TextRange.beg

var eloc = docObj.TextLocToElementLoc(tloc)

var ele = eloc.child

if (ele.ElementDef.Name == targetElemName){
	
	var attr1 =ele.Attributes
	var idval1 = attr1[1].values
	var arr = idval1[0].split("/")
	if (targetIdval[0] == arr[1]) 
	{
	count++
	}

}
ti = ti.NextTiInDoc
}
 return count;
}

//Function for selecting the target id and the element

function goForKill() {
	
doc= app.ActiveDoc
if (doc.id==0) {
	Alert("There is no active document",1)
	return;
}

//Finding the id of the Selected Element
 
elemRange = doc.ElementSelection

elem = elemRange.beg.child

targetElemName = elem.ElementDef.Name //stores the name of the target element

attr = elem.Attributes

targetIdval = attr[0].values  //It stores the id value which is to be searched
if (targetIdval == "") {
	Alert("No Id is assigned", 1)
	return
}
arrList = new Array()
openAllTopicRefs(edText)
Publish()
}

//For Publishing the results 

function Publish() {
	var lent = arrList.length
	
	if (lent > 0) {
		Alert("Files found are\n"+arrList,1)
	} 
	else {
		Alert("No reference found",1)
	}
}



function convertConref () {
	
var i=0

var d = app.ActiveDoc.FirstTiInDoc

var selectedTi = app.ActiveDoc.FirstSelectedTiInDoc
if ( selectedTi.id != 0) {
	selectedTi.ConvertToText()
	Alert("selected conref flattened",2)
	return 0;
}
	
if (d.id==0) {
	Alert("There are no conrefs",2)
	return 0;
}
while (d.id != 0) {
	
	
	var next = d.NextTiInDoc;
	
	var tloc = d.TextRange.beg

	var eloc = app.ActiveDoc.TextLocToElementLoc(tloc)

	var ele = eloc.child
	var attr2 = ele.Attributes
	attr2[1].values[0] = ""
	ele.Attributes = attr2
	
	d.ConvertToText()
	d = next;
	i++
	
}
return i;
}


function openinvisible(filename)
{
var openProp = GetOpenDefaultParams()

var i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_MakeVisible)
openProp[i].propVal.ival=false

i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
openProp[i].propVal.ival=Constants.FV_DoCancel

i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
openProp[i].propVal.ival=Constants.FV_DoCancel

i=GetPropIndex(openProp,Constants.FS_LockCantBeReset)
openProp[i].propVal.ival=Constants.FV_DoOK

var retParm = new PropVals()
var fileObj=Open(filename,openProp,retParm);
return fileObj
}


function convertConrefDitaMap(dobj) {
	
var i=0

var d = dobj.FirstTiInDoc



while (d.id != 0) {
	
	
	var next = d.NextTiInDoc;
	
	var tloc = d.TextRange.beg

	var eloc = dobj.TextLocToElementLoc(tloc)

	var ele = eloc.child
	var attr2 = ele.Attributes
    
    if  (ele.ElementDef.Name != "xref") 
    {
    
    var t=0
    while (t < attr2.len) {
        if (attr2[t].name == "conref" ) {
            i++
        break;
        }
        else 
        t++        
     }
        
    
    
	attr2[t].values[0] = ""
	ele.Attributes = attr2

	
	d.ConvertToText()
	d = next;
	}
    else {
      d = next;
     }
	
}
return i;
}


function saveXml(inputFile,strPath)  {
    var params = GetSaveDefaultParams()
var returnParamsp =new PropVals()
var i = GetPropIndex(params, FS_FileType)
params[i].propVal.ival =FV_SaveFmtXml

//doc2save = SimpleOpen("D:\\extendscript\\myScripts\\tfiles\\SimpleOpen.fm",0);
inputFile.Save(strPath, params, returnParamsp)
return;
}



function open(filename)
{
var openProp = GetOpenDefaultParams()

var i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_MakeVisible)
openProp[i].propVal.ival=true

i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
openProp[i].propVal.ival=Constants.FV_DoOK

i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
openProp[i].propVal.ival=Constants.FV_DoCancel

i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
openProp[i].propVal.ival=Constants.FV_DoCancel

i=GetPropIndex(openProp,Constants.FS_LockCantBeReset)
openProp[i].propVal.ival=Constants.FV_DoOK

var retParm = new PropVals()
var fileObj=Open(filename,openProp,retParm);
return fileObj
}